@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A database data masking policy.
 * @property applicationPrincipals The list of the application principals. This is a legacy parameter and is no longer used.
 * @property dataMaskingState The state of the data masking policy.
 * @property exemptPrincipals The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
 * @property id Resource ID.
 * @property kind The kind of Data Masking Policy. Metadata, used for Azure portal.
 * @property location The location of the data masking policy.
 * @property maskingLevel The masking level. This is a legacy parameter and is no longer used.
 * @property name Resource name.
 * @property type Resource type.
 */
public data class GetDataMaskingPolicyResult(
    public val applicationPrincipals: String,
    public val dataMaskingState: String,
    public val exemptPrincipals: String? = null,
    public val id: String,
    public val kind: String,
    public val location: String,
    public val maskingLevel: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetDataMaskingPolicyResult): GetDataMaskingPolicyResult = GetDataMaskingPolicyResult(
            applicationPrincipals = javaType.applicationPrincipals(),
            dataMaskingState = javaType.dataMaskingState(),
            exemptPrincipals = javaType.exemptPrincipals().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            maskingLevel = javaType.maskingLevel(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
