@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A database vulnerability assessment rule baseline.
 * @property baselineResults The rule baseline result
 * @property id Resource ID.
 * @property name Resource name.
 * @property type Resource type.
 */
public data class GetDatabaseVulnerabilityAssessmentRuleBaselineResult(
    public val baselineResults: List<DatabaseVulnerabilityAssessmentRuleBaselineItemResponse>,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetDatabaseVulnerabilityAssessmentRuleBaselineResult): GetDatabaseVulnerabilityAssessmentRuleBaselineResult =
            GetDatabaseVulnerabilityAssessmentRuleBaselineResult(
                baselineResults = javaType.baselineResults().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.DatabaseVulnerabilityAssessmentRuleBaselineItemResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
