@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Distributed availability group between box and Sql Managed Instance.
 * @property distributedAvailabilityGroupId The distributed availability group id
 * @property id Resource ID.
 * @property lastHardenedLsn The last hardened lsn
 * @property linkState The link state
 * @property name Resource name.
 * @property primaryAvailabilityGroupName The primary availability group name
 * @property replicationMode The replication mode of a distributed availability group. Parameter will be ignored during link creation.
 * @property secondaryAvailabilityGroupName The secondary availability group name
 * @property sourceEndpoint The source endpoint
 * @property sourceReplicaId The source replica id
 * @property targetDatabase The name of the target database
 * @property targetReplicaId The target replica id
 * @property type Resource type.
 */
public data class GetDistributedAvailabilityGroupResult(
    public val distributedAvailabilityGroupId: String,
    public val id: String,
    public val lastHardenedLsn: String,
    public val linkState: String,
    public val name: String,
    public val primaryAvailabilityGroupName: String? = null,
    public val replicationMode: String? = null,
    public val secondaryAvailabilityGroupName: String? = null,
    public val sourceEndpoint: String? = null,
    public val sourceReplicaId: String,
    public val targetDatabase: String? = null,
    public val targetReplicaId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetDistributedAvailabilityGroupResult): GetDistributedAvailabilityGroupResult = GetDistributedAvailabilityGroupResult(
            distributedAvailabilityGroupId = javaType.distributedAvailabilityGroupId(),
            id = javaType.id(),
            lastHardenedLsn = javaType.lastHardenedLsn(),
            linkState = javaType.linkState(),
            name = javaType.name(),
            primaryAvailabilityGroupName = javaType.primaryAvailabilityGroupName().map({ args0 ->
                args0
            }).orElse(null),
            replicationMode = javaType.replicationMode().map({ args0 -> args0 }).orElse(null),
            secondaryAvailabilityGroupName = javaType.secondaryAvailabilityGroupName().map({ args0 ->
                args0
            }).orElse(null),
            sourceEndpoint = javaType.sourceEndpoint().map({ args0 -> args0 }).orElse(null),
            sourceReplicaId = javaType.sourceReplicaId(),
            targetDatabase = javaType.targetDatabase().map({ args0 -> args0 }).orElse(null),
            targetReplicaId = javaType.targetReplicaId(),
            type = javaType.type(),
        )
    }
}
