@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An elastic pool.
 * @property creationDate The creation date of the elastic pool (ISO8601 format).
 * @property highAvailabilityReplicaCount The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools.
 * @property id Resource ID.
 * @property kind Kind of elastic pool. This is metadata used for the Azure portal experience.
 * @property licenseType The license type to apply for this elastic pool.
 * @property location Resource location.
 * @property maintenanceConfigurationId Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
 * @property maxSizeBytes The storage limit for the database elastic pool in bytes.
 * @property minCapacity Minimal capacity that serverless pool will not shrink below, if not paused
 * @property name Resource name.
 * @property perDatabaseSettings The per database settings for the elastic pool.
 * @property sku The elastic pool SKU.
 * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
 * ```azurecli
 * az sql elastic-pool list-editions -l <location> -o table
 * ````
 * @property state The state of the elastic pool.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zoneRedundant Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
 */
public data class GetElasticPoolResult(
    public val creationDate: String,
    public val highAvailabilityReplicaCount: Int? = null,
    public val id: String,
    public val kind: String,
    public val licenseType: String? = null,
    public val location: String,
    public val maintenanceConfigurationId: String? = null,
    public val maxSizeBytes: Double? = null,
    public val minCapacity: Double? = null,
    public val name: String,
    public val perDatabaseSettings: ElasticPoolPerDatabaseSettingsResponse? = null,
    public val sku: SkuResponse? = null,
    public val state: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetElasticPoolResult): GetElasticPoolResult = GetElasticPoolResult(
            creationDate = javaType.creationDate(),
            highAvailabilityReplicaCount = javaType.highAvailabilityReplicaCount().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            maintenanceConfigurationId = javaType.maintenanceConfigurationId().map({ args0 ->
                args0
            }).orElse(null),
            maxSizeBytes = javaType.maxSizeBytes().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            perDatabaseSettings = javaType.perDatabaseSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ElasticPoolPerDatabaseSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
