@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A failover group.
 * @property databases List of databases in the failover group.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property partnerServers List of partner server information for the failover group.
 * @property readOnlyEndpoint Read-only endpoint of the failover group instance.
 * @property readWriteEndpoint Read-write endpoint of the failover group instance.
 * @property replicationRole Local replication role of the failover group instance.
 * @property replicationState Replication state of the failover group instance.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetFailoverGroupResult(
    public val databases: List<String>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val partnerServers: List<PartnerInfoResponse>,
    public val readOnlyEndpoint: FailoverGroupReadOnlyEndpointResponse? = null,
    public val readWriteEndpoint: FailoverGroupReadWriteEndpointResponse,
    public val replicationRole: String,
    public val replicationState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetFailoverGroupResult): GetFailoverGroupResult = GetFailoverGroupResult(
            databases = javaType.databases().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            partnerServers = javaType.partnerServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.PartnerInfoResponse.Companion.toKotlin(args0)
                })
            }),
            readOnlyEndpoint = javaType.readOnlyEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.FailoverGroupReadOnlyEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readWriteEndpoint = javaType.readWriteEndpoint().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.FailoverGroupReadWriteEndpointResponse.Companion.toKotlin(args0)
            }),
            replicationRole = javaType.replicationRole(),
            replicationState = javaType.replicationState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
