@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A server firewall rule.
 * @property endIpAddress The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP addresses.
 * @property id Resource ID.
 * @property name Resource name.
 * @property startIpAddress The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' for all Azure-internal IP addresses.
 * @property type Resource type.
 */
public data class GetFirewallRuleResult(
    public val endIpAddress: String? = null,
    public val id: String,
    public val name: String? = null,
    public val startIpAddress: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetFirewallRuleResult): GetFirewallRuleResult = GetFirewallRuleResult(
            endIpAddress = javaType.endIpAddress().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            startIpAddress = javaType.startIpAddress().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
