@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Geo backup policy.
 * @property id Resource ID.
 * @property kind Kind of geo backup policy.  This is metadata used for the Azure portal experience.
 * @property location Backup policy location.
 * @property name Resource name.
 * @property state The state of the geo backup policy.
 * @property storageType The storage type of the geo backup policy.
 * @property type Resource type.
 */
public data class GetGeoBackupPolicyResult(
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val state: String,
    public val storageType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetGeoBackupPolicyResult): GetGeoBackupPolicyResult = GetGeoBackupPolicyResult(
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            state = javaType.state(),
            storageType = javaType.storageType(),
            type = javaType.type(),
        )
    }
}
