@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An IPv6 server firewall rule.
 * @property endIPv6Address The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
 * @property id Resource ID.
 * @property name Resource name.
 * @property startIPv6Address The start IP address of the firewall rule. Must be IPv6 format.
 * @property type Resource type.
 */
public data class GetIPv6FirewallRuleResult(
    public val endIPv6Address: String? = null,
    public val id: String,
    public val name: String? = null,
    public val startIPv6Address: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetIPv6FirewallRuleResult): GetIPv6FirewallRuleResult = GetIPv6FirewallRuleResult(
            endIPv6Address = javaType.endIPv6Address().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            startIPv6Address = javaType.startIPv6Address().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
