@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure SQL instance pool.
 * @property id Resource ID.
 * @property licenseType The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
 * @property location Resource location.
 * @property name Resource name.
 * @property sku The name and tier of the SKU.
 * @property subnetId Resource ID of the subnet to place this instance pool in.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property vCores Count of vCores belonging to this instance pool.
 */
public data class GetInstancePoolResult(
    public val id: String,
    public val licenseType: String,
    public val location: String,
    public val name: String,
    public val sku: SkuResponse? = null,
    public val subnetId: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vCores: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetInstancePoolResult): GetInstancePoolResult = GetInstancePoolResult(
            id = javaType.id(),
            licenseType = javaType.licenseType(),
            location = javaType.location(),
            name = javaType.name(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnetId = javaType.subnetId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vCores = javaType.vCores(),
        )
    }
}
