@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A stored credential that can be used by a job to connect to target databases.
 * @property id Resource ID.
 * @property name Resource name.
 * @property type Resource type.
 * @property username The credential user name.
 */
public data class GetJobCredentialResult(
    public val id: String,
    public val name: String,
    public val type: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetJobCredentialResult): GetJobCredentialResult = GetJobCredentialResult(
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
            username = javaType.username(),
        )
    }
}
