@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A job agent private endpoint.
 * @property id Resource ID.
 * @property name Resource name.
 * @property privateEndpointId Private endpoint id of the private endpoint.
 * @property targetServerAzureResourceId ARM resource id of the server the private endpoint will target.
 * @property type Resource type.
 */
public data class GetJobPrivateEndpointResult(
    public val id: String,
    public val name: String,
    public val privateEndpointId: String,
    public val targetServerAzureResourceId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetJobPrivateEndpointResult): GetJobPrivateEndpointResult = GetJobPrivateEndpointResult(
            id = javaType.id(),
            name = javaType.name(),
            privateEndpointId = javaType.privateEndpointId(),
            targetServerAzureResourceId = javaType.targetServerAzureResourceId(),
            type = javaType.type(),
        )
    }
}
