@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A managed database resource.
 * @property catalogCollation Collation of the metadata catalog.
 * @property collation Collation of the managed database.
 * @property creationDate Creation date of the database.
 * @property defaultSecondaryLocation Geo paired region.
 * @property earliestRestorePoint Earliest restore point in time for point in time restore.
 * @property failoverGroupId Instance Failover Group resource identifier that this managed database belongs to.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property status Status of the database.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetManagedDatabaseResult(
    public val catalogCollation: String? = null,
    public val collation: String? = null,
    public val creationDate: String,
    public val defaultSecondaryLocation: String,
    public val earliestRestorePoint: String,
    public val failoverGroupId: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedDatabaseResult): GetManagedDatabaseResult = GetManagedDatabaseResult(
            catalogCollation = javaType.catalogCollation().map({ args0 -> args0 }).orElse(null),
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            creationDate = javaType.creationDate(),
            defaultSecondaryLocation = javaType.defaultSecondaryLocation(),
            earliestRestorePoint = javaType.earliestRestorePoint(),
            failoverGroupId = javaType.failoverGroupId(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
