@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Azure Active Directory only authentication.
 * @property azureADOnlyAuthentication Azure Active Directory only Authentication enabled.
 * @property id Resource ID.
 * @property name Resource name.
 * @property type Resource type.
 */
public data class GetManagedInstanceAzureADOnlyAuthenticationResult(
    public val azureADOnlyAuthentication: Boolean,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedInstanceAzureADOnlyAuthenticationResult): GetManagedInstanceAzureADOnlyAuthenticationResult =
            GetManagedInstanceAzureADOnlyAuthenticationResult(
                azureADOnlyAuthentication = javaType.azureADOnlyAuthentication(),
                id = javaType.id(),
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
