@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Azure SQL managed instance.
 * @property administratorLogin Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
 * @property administrators The Azure Active Directory administrator of the server.
 * @property collation Collation of the managed instance.
 * @property currentBackupStorageRedundancy The storage account type used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
 * @property dnsZone The Dns Zone that the managed instance is in.
 * @property fullyQualifiedDomainName The fully qualified domain name of the managed instance.
 * @property id Resource ID.
 * @property identity The Azure Active Directory identity of the managed instance.
 * @property instancePoolId The Id of the instance pool this managed server belongs to.
 * @property keyId A CMK URI of the key to use for encryption.
 * @property licenseType The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
 * @property location Resource location.
 * @property maintenanceConfigurationId Specifies maintenance configuration id to apply to this managed instance.
 * @property minimalTlsVersion Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
 * @property name Resource name.
 * @property primaryUserAssignedIdentityId The resource id of a user assigned identity to be used by default.
 * @property privateEndpointConnections List of private endpoint connections on a managed instance.
 * @property provisioningState
 * @property proxyOverride Connection type used for connecting to the instance.
 * @property publicDataEndpointEnabled Whether or not the public data endpoint is enabled.
 * @property requestedBackupStorageRedundancy The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
 * @property servicePrincipal The managed instance's service principal.
 * @property sku Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
 * @property state The state of the managed instance.
 * @property storageSizeInGB Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
 * @property subnetId Subnet resource ID for the managed instance.
 * @property tags Resource tags.
 * @property timezoneId Id of the timezone. Allowed values are timezones supported by Windows.
 * Windows keeps details on supported timezones, including the id, in registry under
 * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
 * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
 * List of Ids can also be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
 * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
 * @property type Resource type.
 * @property vCores The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
 * @property zoneRedundant Whether or not the multi-az is enabled.
 */
public data class GetManagedInstanceResult(
    public val administratorLogin: String? = null,
    public val administrators: ManagedInstanceExternalAdministratorResponse? = null,
    public val collation: String? = null,
    public val currentBackupStorageRedundancy: String,
    public val dnsZone: String,
    public val fullyQualifiedDomainName: String,
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val instancePoolId: String? = null,
    public val keyId: String? = null,
    public val licenseType: String? = null,
    public val location: String,
    public val maintenanceConfigurationId: String? = null,
    public val minimalTlsVersion: String? = null,
    public val name: String,
    public val primaryUserAssignedIdentityId: String? = null,
    public val privateEndpointConnections: List<ManagedInstancePecPropertyResponse>,
    public val provisioningState: String,
    public val proxyOverride: String? = null,
    public val publicDataEndpointEnabled: Boolean? = null,
    public val requestedBackupStorageRedundancy: String? = null,
    public val servicePrincipal: ServicePrincipalResponse? = null,
    public val sku: SkuResponse? = null,
    public val state: String,
    public val storageSizeInGB: Int? = null,
    public val subnetId: String? = null,
    public val tags: Map<String, String>? = null,
    public val timezoneId: String? = null,
    public val type: String,
    public val vCores: Int? = null,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedInstanceResult): GetManagedInstanceResult = GetManagedInstanceResult(
            administratorLogin = javaType.administratorLogin().map({ args0 -> args0 }).orElse(null),
            administrators = javaType.administrators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstanceExternalAdministratorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            currentBackupStorageRedundancy = javaType.currentBackupStorageRedundancy(),
            dnsZone = javaType.dnsZone(),
            fullyQualifiedDomainName = javaType.fullyQualifiedDomainName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instancePoolId = javaType.instancePoolId().map({ args0 -> args0 }).orElse(null),
            keyId = javaType.keyId().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            maintenanceConfigurationId = javaType.maintenanceConfigurationId().map({ args0 ->
                args0
            }).orElse(null),
            minimalTlsVersion = javaType.minimalTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            primaryUserAssignedIdentityId = javaType.primaryUserAssignedIdentityId().map({ args0 ->
                args0
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePecPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            proxyOverride = javaType.proxyOverride().map({ args0 -> args0 }).orElse(null),
            publicDataEndpointEnabled = javaType.publicDataEndpointEnabled().map({ args0 ->
                args0
            }).orElse(null),
            requestedBackupStorageRedundancy = javaType.requestedBackupStorageRedundancy().map({ args0 ->
                args0
            }).orElse(null),
            servicePrincipal = javaType.servicePrincipal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ServicePrincipalResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            storageSizeInGB = javaType.storageSizeInGB().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timezoneId = javaType.timezoneId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            vCores = javaType.vCores().map({ args0 -> args0 }).orElse(null),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
