@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A managed server DNS alias.
 * @property azureDnsRecord The fully qualified DNS record for managed server alias
 * @property id Resource ID.
 * @property name Resource name.
 * @property publicAzureDnsRecord The fully qualified public DNS record for managed server alias
 * @property type Resource type.
 */
public data class GetManagedServerDnsAliasResult(
    public val azureDnsRecord: String,
    public val id: String,
    public val name: String,
    public val publicAzureDnsRecord: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedServerDnsAliasResult): GetManagedServerDnsAliasResult = GetManagedServerDnsAliasResult(
            azureDnsRecord = javaType.azureDnsRecord(),
            id = javaType.id(),
            name = javaType.name(),
            publicAzureDnsRecord = javaType.publicAzureDnsRecord(),
            type = javaType.type(),
        )
    }
}
