@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A sensitivity label.
 * @property columnName The column name.
 * @property id Resource ID.
 * @property informationType The information type.
 * @property informationTypeId The information type ID.
 * @property isDisabled Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
 * @property labelId The label ID.
 * @property labelName The label name.
 * @property managedBy Resource that manages the sensitivity label.
 * @property name Resource name.
 * @property rank
 * @property schemaName The schema name.
 * @property tableName The table name.
 * @property type Resource type.
 */
public data class GetSensitivityLabelResult(
    public val columnName: String,
    public val id: String,
    public val informationType: String? = null,
    public val informationTypeId: String? = null,
    public val isDisabled: Boolean,
    public val labelId: String? = null,
    public val labelName: String? = null,
    public val managedBy: String,
    public val name: String,
    public val rank: String? = null,
    public val schemaName: String,
    public val tableName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetSensitivityLabelResult): GetSensitivityLabelResult = GetSensitivityLabelResult(
            columnName = javaType.columnName(),
            id = javaType.id(),
            informationType = javaType.informationType().map({ args0 -> args0 }).orElse(null),
            informationTypeId = javaType.informationTypeId().map({ args0 -> args0 }).orElse(null),
            isDisabled = javaType.isDisabled(),
            labelId = javaType.labelId().map({ args0 -> args0 }).orElse(null),
            labelName = javaType.labelName().map({ args0 -> args0 }).orElse(null),
            managedBy = javaType.managedBy(),
            name = javaType.name(),
            rank = javaType.rank().map({ args0 -> args0 }).orElse(null),
            schemaName = javaType.schemaName(),
            tableName = javaType.tableName(),
            type = javaType.type(),
        )
    }
}
