@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Server communication link.
 * @property id Resource ID.
 * @property kind Communication link kind.  This property is used for Azure Portal metadata.
 * @property location Communication link location.
 * @property name Resource name.
 * @property partnerServer The name of the partner server.
 * @property state The state.
 * @property type Resource type.
 */
public data class GetServerCommunicationLinkResult(
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val partnerServer: String,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerCommunicationLinkResult): GetServerCommunicationLinkResult = GetServerCommunicationLinkResult(
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            partnerServer = javaType.partnerServer(),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
