@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A server DNS alias.
 * @property azureDnsRecord The fully qualified DNS record for alias
 * @property id Resource ID.
 * @property name Resource name.
 * @property type Resource type.
 */
public data class GetServerDnsAliasResult(
    public val azureDnsRecord: String,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerDnsAliasResult): GetServerDnsAliasResult = GetServerDnsAliasResult(
            azureDnsRecord = javaType.azureDnsRecord(),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
