@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A server key.
 * @property autoRotationEnabled Key auto rotation opt-in flag. Either true or false.
 * @property creationDate The server key creation date.
 * @property id Resource ID.
 * @property kind Kind of encryption protector. This is metadata used for the Azure portal experience.
 * @property location Resource location.
 * @property name Resource name.
 * @property subregion Subregion of the server key.
 * @property thumbprint Thumbprint of the server key.
 * @property type Resource type.
 */
public data class GetServerKeyResult(
    public val autoRotationEnabled: Boolean,
    public val creationDate: String,
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val subregion: String,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerKeyResult): GetServerKeyResult = GetServerKeyResult(
            autoRotationEnabled = javaType.autoRotationEnabled(),
            creationDate = javaType.creationDate(),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            subregion = javaType.subregion(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
