@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A server security alert policy.
 * @property creationTime Specifies the UTC creation time of the policy.
 * @property disabledAlerts Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
 * @property emailAccountAdmins Specifies that the alert is sent to the account administrators.
 * @property emailAddresses Specifies an array of e-mail addresses to which the alert is sent.
 * @property id Resource ID.
 * @property name Resource name.
 * @property retentionDays Specifies the number of days to keep in the Threat Detection audit logs.
 * @property state Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
 * @property storageAccountAccessKey Specifies the identifier key of the Threat Detection audit storage account.
 * @property storageEndpoint Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
 * @property systemData SystemData of SecurityAlertPolicyResource.
 * @property type Resource type.
 */
public data class GetServerSecurityAlertPolicyResult(
    public val creationTime: String,
    public val disabledAlerts: List<String>? = null,
    public val emailAccountAdmins: Boolean? = null,
    public val emailAddresses: List<String>? = null,
    public val id: String,
    public val name: String,
    public val retentionDays: Int? = null,
    public val state: String,
    public val storageAccountAccessKey: String? = null,
    public val storageEndpoint: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerSecurityAlertPolicyResult): GetServerSecurityAlertPolicyResult = GetServerSecurityAlertPolicyResult(
            creationTime = javaType.creationTime(),
            disabledAlerts = javaType.disabledAlerts().map({ args0 -> args0 }),
            emailAccountAdmins = javaType.emailAccountAdmins().map({ args0 -> args0 }).orElse(null),
            emailAddresses = javaType.emailAddresses().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            retentionDays = javaType.retentionDays().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            storageAccountAccessKey = javaType.storageAccountAccessKey().map({ args0 -> args0 }).orElse(null),
            storageEndpoint = javaType.storageEndpoint().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
