@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A server trust group.
 * @property groupMembers Group members information for the server trust group.
 * @property id Resource ID.
 * @property name Resource name.
 * @property trustScopes Trust scope of the server trust group.
 * @property type Resource type.
 */
public data class GetServerTrustGroupResult(
    public val groupMembers: List<ServerInfoResponse>,
    public val id: String,
    public val name: String,
    public val trustScopes: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerTrustGroupResult): GetServerTrustGroupResult = GetServerTrustGroupResult(
            groupMembers = javaType.groupMembers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ServerInfoResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            trustScopes = javaType.trustScopes().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
