@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A database sql vulnerability assessment rule baseline.
 * @property id Resource ID.
 * @property name Resource name.
 * @property results The rule baseline result
 * @property systemData SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineResource.
 * @property type Resource type.
 */
public data class GetSqlVulnerabilityAssessmentRuleBaselineResult(
    public val id: String,
    public val name: String,
    public val results: List<List<String>>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetSqlVulnerabilityAssessmentRuleBaselineResult): GetSqlVulnerabilityAssessmentRuleBaselineResult =
            GetSqlVulnerabilityAssessmentRuleBaselineResult(
                id = javaType.id(),
                name = javaType.name(),
                results = javaType.results().map({ args0 -> args0.map({ args0 -> args0 }) }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
