@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A SQL Vulnerability Assessment.
 * @property id Resource ID.
 * @property name Resource name.
 * @property state Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
 * @property systemData SystemData of SqlVulnerabilityAssessmentResource.
 * @property type Resource type.
 */
public data class GetSqlVulnerabilityAssessmentsSettingResult(
    public val id: String,
    public val name: String,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetSqlVulnerabilityAssessmentsSettingResult): GetSqlVulnerabilityAssessmentsSettingResult = GetSqlVulnerabilityAssessmentsSettingResult(
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
