@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An Azure SQL Database sync agent.
 * @property expiryTime Expiration time of the sync agent version.
 * @property id Resource ID.
 * @property isUpToDate If the sync agent version is up to date.
 * @property lastAliveTime Last alive time of the sync agent.
 * @property name Resource name.
 * @property state State of the sync agent.
 * @property syncDatabaseId ARM resource id of the sync database in the sync agent.
 * @property type Resource type.
 * @property version Version of the sync agent.
 */
public data class GetSyncAgentResult(
    public val expiryTime: String,
    public val id: String,
    public val isUpToDate: Boolean,
    public val lastAliveTime: String,
    public val name: String,
    public val state: String,
    public val syncDatabaseId: String? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetSyncAgentResult): GetSyncAgentResult = GetSyncAgentResult(
            expiryTime = javaType.expiryTime(),
            id = javaType.id(),
            isUpToDate = javaType.isUpToDate(),
            lastAliveTime = javaType.lastAliveTime(),
            name = javaType.name(),
            state = javaType.state(),
            syncDatabaseId = javaType.syncDatabaseId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
