@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An Azure SQL Database sync group.
 * @property conflictLoggingRetentionInDays Conflict logging retention period.
 * @property conflictResolutionPolicy Conflict resolution policy of the sync group.
 * @property enableConflictLogging If conflict logging is enabled.
 * @property hubDatabaseUserName User name for the sync group hub database credential.
 * @property id Resource ID.
 * @property interval Sync interval of the sync group.
 * @property lastSyncTime Last sync time of the sync group.
 * @property name Resource name.
 * @property privateEndpointName Private endpoint name of the sync group if use private link connection is enabled.
 * @property schema Sync schema of the sync group.
 * @property sku The name and capacity of the SKU.
 * @property syncDatabaseId ARM resource id of the sync database in the sync group.
 * @property syncState Sync state of the sync group.
 * @property type Resource type.
 * @property usePrivateLinkConnection If use private link connection is enabled.
 */
public data class GetSyncGroupResult(
    public val conflictLoggingRetentionInDays: Int? = null,
    public val conflictResolutionPolicy: String? = null,
    public val enableConflictLogging: Boolean? = null,
    public val hubDatabaseUserName: String? = null,
    public val id: String,
    public val interval: Int? = null,
    public val lastSyncTime: String,
    public val name: String,
    public val privateEndpointName: String,
    public val schema: SyncGroupSchemaResponse? = null,
    public val sku: SkuResponse? = null,
    public val syncDatabaseId: String? = null,
    public val syncState: String,
    public val type: String,
    public val usePrivateLinkConnection: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetSyncGroupResult): GetSyncGroupResult = GetSyncGroupResult(
            conflictLoggingRetentionInDays = javaType.conflictLoggingRetentionInDays().map({ args0 ->
                args0
            }).orElse(null),
            conflictResolutionPolicy = javaType.conflictResolutionPolicy().map({ args0 -> args0 }).orElse(null),
            enableConflictLogging = javaType.enableConflictLogging().map({ args0 -> args0 }).orElse(null),
            hubDatabaseUserName = javaType.hubDatabaseUserName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            lastSyncTime = javaType.lastSyncTime(),
            name = javaType.name(),
            privateEndpointName = javaType.privateEndpointName(),
            schema = javaType.schema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SyncGroupSchemaResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            syncDatabaseId = javaType.syncDatabaseId().map({ args0 -> args0 }).orElse(null),
            syncState = javaType.syncState(),
            type = javaType.type(),
            usePrivateLinkConnection = javaType.usePrivateLinkConnection().map({ args0 -> args0 }).orElse(null),
        )
    }
}
