@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Workload classifier operations for a data warehouse
 * @property context The workload classifier context.
 * @property endTime The workload classifier end time for classification.
 * @property id Resource ID.
 * @property importance The workload classifier importance.
 * @property label The workload classifier label.
 * @property memberName The workload classifier member name.
 * @property name Resource name.
 * @property startTime The workload classifier start time for classification.
 * @property type Resource type.
 */
public data class GetWorkloadClassifierResult(
    public val context: String? = null,
    public val endTime: String? = null,
    public val id: String,
    public val importance: String? = null,
    public val label: String? = null,
    public val memberName: String,
    public val name: String,
    public val startTime: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetWorkloadClassifierResult): GetWorkloadClassifierResult = GetWorkloadClassifierResult(
            context = javaType.context().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            importance = javaType.importance().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            memberName = javaType.memberName(),
            name = javaType.name(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
