@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Read-write endpoint of the failover group instance.
 * @property failoverPolicy Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
 * @property failoverWithDataLossGracePeriodMinutes Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
 */
public data class InstanceFailoverGroupReadWriteEndpointResponse(
    public val failoverPolicy: String,
    public val failoverWithDataLossGracePeriodMinutes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.InstanceFailoverGroupReadWriteEndpointResponse): InstanceFailoverGroupReadWriteEndpointResponse =
            InstanceFailoverGroupReadWriteEndpointResponse(
                failoverPolicy = javaType.failoverPolicy(),
                failoverWithDataLossGracePeriodMinutes = javaType.failoverWithDataLossGracePeriodMinutes().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
