@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Scheduling properties of a job.
 * @property enabled Whether or not the schedule is enabled.
 * @property endTime Schedule end time.
 * @property interval Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
 * @property startTime Schedule start time.
 * @property type Schedule interval type
 */
public data class JobScheduleResponse(
    public val enabled: Boolean? = null,
    public val endTime: String? = null,
    public val interval: String? = null,
    public val startTime: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.JobScheduleResponse): JobScheduleResponse = JobScheduleResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
