@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * The execution options of a job step.
 * @property initialRetryIntervalSeconds Initial delay between retries for job step execution.
 * @property maximumRetryIntervalSeconds The maximum amount of time to wait between retries for job step execution.
 * @property retryAttempts Maximum number of times the job step will be reattempted if the first attempt fails.
 * @property retryIntervalBackoffMultiplier The backoff multiplier for the time between retries.
 * @property timeoutSeconds Execution timeout for the job step.
 */
public data class JobStepExecutionOptionsResponse(
    public val initialRetryIntervalSeconds: Int? = null,
    public val maximumRetryIntervalSeconds: Int? = null,
    public val retryAttempts: Int? = null,
    public val retryIntervalBackoffMultiplier: Double? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.JobStepExecutionOptionsResponse): JobStepExecutionOptionsResponse = JobStepExecutionOptionsResponse(
            initialRetryIntervalSeconds = javaType.initialRetryIntervalSeconds().map({ args0 ->
                args0
            }).orElse(null),
            maximumRetryIntervalSeconds = javaType.maximumRetryIntervalSeconds().map({ args0 ->
                args0
            }).orElse(null),
            retryAttempts = javaType.retryAttempts().map({ args0 -> args0 }).orElse(null),
            retryIntervalBackoffMultiplier = javaType.retryIntervalBackoffMultiplier().map({ args0 ->
                args0
            }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
