@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The output configuration of a job step.
 * @property credential The resource ID of the credential to use to connect to the output destination.
 * @property databaseName The output destination database.
 * @property resourceGroupName The output destination resource group.
 * @property schemaName The output destination schema.
 * @property serverName The output destination server name.
 * @property subscriptionId The output destination subscription id.
 * @property tableName The output destination table.
 * @property type The output destination type.
 */
public data class JobStepOutputResponse(
    public val credential: String,
    public val databaseName: String,
    public val resourceGroupName: String? = null,
    public val schemaName: String? = null,
    public val serverName: String,
    public val subscriptionId: String? = null,
    public val tableName: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.JobStepOutputResponse): JobStepOutputResponse = JobStepOutputResponse(
            credential = javaType.credential(),
            databaseName = javaType.databaseName(),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            schemaName = javaType.schemaName().map({ args0 -> args0 }).orElse(null),
            serverName = javaType.serverName(),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
