@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection under a managed instance
 * @property id Resource ID.
 * @property properties Private endpoint connection properties
 */
public data class ManagedInstancePecPropertyResponse(
    public val id: String,
    public val properties: ManagedInstancePrivateEndpointConnectionPropertiesResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ManagedInstancePecPropertyResponse): ManagedInstancePecPropertyResponse = ManagedInstancePecPropertyResponse(
            id = javaType.id(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
