@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Partner server information for the failover group.
 * @property id Resource identifier of the partner server.
 * @property location Geo location of the partner server.
 * @property replicationRole Replication role of the partner server.
 */
public data class PartnerInfoResponse(
    public val id: String,
    public val location: String,
    public val replicationRole: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.PartnerInfoResponse): PartnerInfoResponse = PartnerInfoResponse(
            id = javaType.id(),
            location = javaType.location(),
            replicationRole = javaType.replicationRole(),
        )
    }
}
