@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a private endpoint connection.
 * @property groupIds Group IDs.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection state of the private endpoint connection.
 * @property provisioningState State of the private endpoint connection.
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val groupIds: List<String>,
    public val privateEndpoint: PrivateEndpointPropertyResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStatePropertyResponse? =
        null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.PrivateEndpointConnectionPropertiesResponse): PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.PrivateEndpointPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.PrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
