@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information for manual implementation for an Azure SQL Database, Server or Elastic Pool Recommended Action.
 * @property method Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell.
 * @property script Gets the manual implementation script. e.g., T-SQL script that could be executed on the database.
 */
public data class RecommendedActionImplementationInfoResponse(
    public val method: String,
    public val script: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.RecommendedActionImplementationInfoResponse): RecommendedActionImplementationInfoResponse = RecommendedActionImplementationInfoResponse(
            method = javaType.method(),
            script = javaType.script(),
        )
    }
}
