@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information of current state for an Azure SQL Database, Server or Elastic Pool Recommended Action.
 * @property actionInitiatedBy Gets who initiated the execution of this recommended action. Possible Value are: User    -> When user explicity notified system to apply the recommended action. System  -> When auto-execute status of this advisor was set to 'Enabled', in which case the system applied it.
 * @property currentValue Current state the recommended action is in. Some commonly used states are: Active      -> recommended action is active and no action has been taken yet. Pending     -> recommended action is approved for and is awaiting execution. Executing   -> recommended action is being applied on the user database. Verifying   -> recommended action was applied and is being verified of its usefulness by the system. Success     -> recommended action was applied and improvement found during verification. Pending Revert  -> verification found little or no improvement so recommended action is queued for revert or user has manually reverted. Reverting   -> changes made while applying recommended action are being reverted on the user database. Reverted    -> successfully reverted the changes made by recommended action on user database. Ignored     -> user explicitly ignored/discarded the recommended action.
 * @property lastModified Gets the time when the state was last modified
 */
public data class RecommendedActionStateInfoResponse(
    public val actionInitiatedBy: String,
    public val currentValue: String,
    public val lastModified: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.RecommendedActionStateInfoResponse): RecommendedActionStateInfoResponse = RecommendedActionStateInfoResponse(
            actionInitiatedBy = javaType.actionInitiatedBy(),
            currentValue = javaType.currentValue(),
            lastModified = javaType.lastModified(),
        )
    }
}
