@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Schedule info describing when the server should be started or stopped.
 * @property startDay Start day.
 * @property startTime Start time.
 * @property stopDay Stop day.
 * @property stopTime Stop time.
 */
public data class ScheduleItemResponse(
    public val startDay: String,
    public val startTime: String,
    public val stopDay: String,
    public val stopTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ScheduleItemResponse): ScheduleItemResponse = ScheduleItemResponse(
            startDay = javaType.startDay(),
            startTime = javaType.startTime(),
            stopDay = javaType.stopDay(),
            stopTime = javaType.stopTime(),
        )
    }
}
