@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Properties of a active directory administrator.
 * @property administratorType Type of the sever administrator.
 * @property azureADOnlyAuthentication Azure Active Directory only Authentication enabled.
 * @property login Login name of the server administrator.
 * @property principalType Principal Type of the sever administrator.
 * @property sid SID (object ID) of the server administrator.
 * @property tenantId Tenant ID of the administrator.
 */
public data class ServerExternalAdministratorResponse(
    public val administratorType: String? = null,
    public val azureADOnlyAuthentication: Boolean? = null,
    public val login: String? = null,
    public val principalType: String? = null,
    public val sid: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ServerExternalAdministratorResponse): ServerExternalAdministratorResponse = ServerExternalAdministratorResponse(
            administratorType = javaType.administratorType().map({ args0 -> args0 }).orElse(null),
            azureADOnlyAuthentication = javaType.azureADOnlyAuthentication().map({ args0 ->
                args0
            }).orElse(null),
            login = javaType.login().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType().map({ args0 -> args0 }).orElse(null),
            sid = javaType.sid().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
