@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The managed instance's service principal configuration for a resource.
 * @property clientId The Azure Active Directory application client id.
 * @property principalId The Azure Active Directory application object id.
 * @property tenantId The Azure Active Directory tenant id.
 * @property type Service principal type.
 */
public data class ServicePrincipalResponse(
    public val clientId: String,
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ServicePrincipalResponse): ServicePrincipalResponse = ServicePrincipalResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
