@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AgConfigurationResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.LoadBalancerConfigurationResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.MultiSubnetIpConfigurationResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AgConfigurationResponse.Companion.toKotlin as agConfigurationResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.LoadBalancerConfigurationResponse.Companion.toKotlin as loadBalancerConfigurationResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.MultiSubnetIpConfigurationResponse.Companion.toKotlin as multiSubnetIpConfigurationResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AvailabilityGroupListener].
 */
@PulumiTagMarker
public class AvailabilityGroupListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AvailabilityGroupListenerArgs = AvailabilityGroupListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AvailabilityGroupListenerArgsBuilder.() -> Unit) {
        val builder = AvailabilityGroupListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AvailabilityGroupListener {
        val builtJavaResource =
            com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AvailabilityGroupListener(builtJavaResource)
    }
}

/**
 * A SQL Server availability group listener.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2017-03-01-preview.
 * Other available API versions: 2023-01-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Creates or updates an availability group listener using load balancer. This is used for VMs present in single subnet.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilityGroupListener = new AzureNative.SqlVirtualMachine.AvailabilityGroupListener("availabilityGroupListener", new()
 *     {
 *         AvailabilityGroupListenerName = "agl-test",
 *         AvailabilityGroupName = "ag-test",
 *         LoadBalancerConfigurations = new[]
 *         {
 *             new AzureNative.SqlVirtualMachine.Inputs.LoadBalancerConfigurationArgs
 *             {
 *                 LoadBalancerResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb-test",
 *                 PrivateIpAddress = new AzureNative.SqlVirtualMachine.Inputs.PrivateIPAddressArgs
 *                 {
 *                     IpAddress = "10.1.0.112",
 *                     SubnetResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *                 },
 *                 ProbePort = 59983,
 *                 SqlVirtualMachineInstances = new[]
 *                 {
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2",
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm3",
 *                 },
 *             },
 *         },
 *         Port = 1433,
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineGroupName = "testvmgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewAvailabilityGroupListener(ctx, "availabilityGroupListener", &sqlvirtualmachine.AvailabilityGroupListenerArgs{
 * 			AvailabilityGroupListenerName: pulumi.String("agl-test"),
 * 			AvailabilityGroupName:         pulumi.String("ag-test"),
 * 			LoadBalancerConfigurations: sqlvirtualmachine.LoadBalancerConfigurationArray{
 * 				&sqlvirtualmachine.LoadBalancerConfigurationArgs{
 * 					LoadBalancerResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb-test"),
 * 					PrivateIpAddress: &sqlvirtualmachine.PrivateIPAddressArgs{
 * 						IpAddress:        pulumi.String("10.1.0.112"),
 * 						SubnetResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 					},
 * 					ProbePort: pulumi.Int(59983),
 * 					SqlVirtualMachineInstances: pulumi.StringArray{
 * 						pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2"),
 * 						pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm3"),
 * 					},
 * 				},
 * 			},
 * 			Port:                       pulumi.Int(1433),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			SqlVirtualMachineGroupName: pulumi.String("testvmgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.LoadBalancerConfigurationArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilityGroupListener = new AvailabilityGroupListener("availabilityGroupListener", AvailabilityGroupListenerArgs.builder()
 *             .availabilityGroupListenerName("agl-test")
 *             .availabilityGroupName("ag-test")
 *             .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                 .loadBalancerResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb-test")
 *                 .privateIpAddress(PrivateIPAddressArgs.builder()
 *                     .ipAddress("10.1.0.112")
 *                     .subnetResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default")
 *                     .build())
 *                 .probePort(59983)
 *                 .sqlVirtualMachineInstances(
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2",
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm3")
 *                 .build())
 *             .port(1433)
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineGroupName("testvmgroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an availability group listener. This is used for VMs present in multi subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilityGroupListener = new AzureNative.SqlVirtualMachine.AvailabilityGroupListener("availabilityGroupListener", new()
 *     {
 *         AvailabilityGroupListenerName = "agl-test",
 *         AvailabilityGroupName = "ag-test",
 *         MultiSubnetIpConfigurations = new[]
 *         {
 *             new AzureNative.SqlVirtualMachine.Inputs.MultiSubnetIpConfigurationArgs
 *             {
 *                 PrivateIpAddress = new AzureNative.SqlVirtualMachine.Inputs.PrivateIPAddressArgs
 *                 {
 *                     IpAddress = "10.0.0.112",
 *                     SubnetResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *                 },
 *                 SqlVirtualMachineInstance = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2",
 *             },
 *             new AzureNative.SqlVirtualMachine.Inputs.MultiSubnetIpConfigurationArgs
 *             {
 *                 PrivateIpAddress = new AzureNative.SqlVirtualMachine.Inputs.PrivateIPAddressArgs
 *                 {
 *                     IpAddress = "10.0.1.112",
 *                     SubnetResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/alternate",
 *                 },
 *                 SqlVirtualMachineInstance = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm1",
 *             },
 *         },
 *         Port = 1433,
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineGroupName = "testvmgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewAvailabilityGroupListener(ctx, "availabilityGroupListener", &sqlvirtualmachine.AvailabilityGroupListenerArgs{
 * 			AvailabilityGroupListenerName: pulumi.String("agl-test"),
 * 			AvailabilityGroupName:         pulumi.String("ag-test"),
 * 			MultiSubnetIpConfigurations: sqlvirtualmachine.MultiSubnetIpConfigurationArray{
 * 				&sqlvirtualmachine.MultiSubnetIpConfigurationArgs{
 * 					PrivateIpAddress: &sqlvirtualmachine.PrivateIPAddressArgs{
 * 						IpAddress:        pulumi.String("10.0.0.112"),
 * 						SubnetResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 					},
 * 					SqlVirtualMachineInstance: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2"),
 * 				},
 * 				&sqlvirtualmachine.MultiSubnetIpConfigurationArgs{
 * 					PrivateIpAddress: &sqlvirtualmachine.PrivateIPAddressArgs{
 * 						IpAddress:        pulumi.String("10.0.1.112"),
 * 						SubnetResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/alternate"),
 * 					},
 * 					SqlVirtualMachineInstance: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm1"),
 * 				},
 * 			},
 * 			Port:                       pulumi.Int(1433),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			SqlVirtualMachineGroupName: pulumi.String("testvmgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.MultiSubnetIpConfigurationArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilityGroupListener = new AvailabilityGroupListener("availabilityGroupListener", AvailabilityGroupListenerArgs.builder()
 *             .availabilityGroupListenerName("agl-test")
 *             .availabilityGroupName("ag-test")
 *             .multiSubnetIpConfigurations(
 *                 MultiSubnetIpConfigurationArgs.builder()
 *                     .privateIpAddress(PrivateIPAddressArgs.builder()
 *                         .ipAddress("10.0.0.112")
 *                         .subnetResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default")
 *                         .build())
 *                     .sqlVirtualMachineInstance("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2")
 *                     .build(),
 *                 MultiSubnetIpConfigurationArgs.builder()
 *                     .privateIpAddress(PrivateIPAddressArgs.builder()
 *                         .ipAddress("10.0.1.112")
 *                         .subnetResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/alternate")
 *                         .build())
 *                     .sqlVirtualMachineInstance("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm1")
 *                     .build())
 *             .port(1433)
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineGroupName("testvmgroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sqlvirtualmachine:AvailabilityGroupListener agl-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/{sqlVirtualMachineGroupName}/availabilityGroupListeners/{availabilityGroupListenerName}
 * ```
 */
public class AvailabilityGroupListener internal constructor(
    override val javaResource: com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener,
) : KotlinCustomResource(javaResource, AvailabilityGroupListenerMapper) {
    /**
     * Availability Group configuration.
     */
    public val availabilityGroupConfiguration: Output<AgConfigurationResponse>?
        get() = javaResource.availabilityGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the availability group.
     */
    public val availabilityGroupName: Output<String>?
        get() = javaResource.availabilityGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Create a default availability group if it does not exist.
     */
    public val createDefaultAvailabilityGroupIfNotExist: Output<Boolean>?
        get() = javaResource.createDefaultAvailabilityGroupIfNotExist().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * List of load balancer configurations for an availability group listener.
     */
    public val loadBalancerConfigurations: Output<List<LoadBalancerConfigurationResponse>>?
        get() = javaResource.loadBalancerConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        loadBalancerConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of multi subnet IP configurations for an AG listener.
     */
    public val multiSubnetIpConfigurations: Output<List<MultiSubnetIpConfigurationResponse>>?
        get() = javaResource.multiSubnetIpConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        multiSubnetIpConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Listener port.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioning state to track the async operation status.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AvailabilityGroupListenerMapper : ResourceMapper<AvailabilityGroupListener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener::class == javaResource::class

    override fun map(javaResource: Resource): AvailabilityGroupListener =
        AvailabilityGroupListener(
            javaResource as
                com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener,
        )
}

/**
 * @see [AvailabilityGroupListener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AvailabilityGroupListener].
 */
public suspend fun availabilityGroupListener(
    name: String,
    block: suspend AvailabilityGroupListenerResourceBuilder.() -> Unit,
): AvailabilityGroupListener {
    val builder = AvailabilityGroupListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AvailabilityGroupListener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun availabilityGroupListener(name: String): AvailabilityGroupListener {
    val builder = AvailabilityGroupListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
