@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AgConfigurationArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AgConfigurationArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.LoadBalancerConfigurationArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.LoadBalancerConfigurationArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.MultiSubnetIpConfigurationArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.MultiSubnetIpConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A SQL Server availability group listener.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2017-03-01-preview.
 * Other available API versions: 2023-01-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Creates or updates an availability group listener using load balancer. This is used for VMs present in single subnet.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilityGroupListener = new AzureNative.SqlVirtualMachine.AvailabilityGroupListener("availabilityGroupListener", new()
 *     {
 *         AvailabilityGroupListenerName = "agl-test",
 *         AvailabilityGroupName = "ag-test",
 *         LoadBalancerConfigurations = new[]
 *         {
 *             new AzureNative.SqlVirtualMachine.Inputs.LoadBalancerConfigurationArgs
 *             {
 *                 LoadBalancerResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb-test",
 *                 PrivateIpAddress = new AzureNative.SqlVirtualMachine.Inputs.PrivateIPAddressArgs
 *                 {
 *                     IpAddress = "10.1.0.112",
 *                     SubnetResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *                 },
 *                 ProbePort = 59983,
 *                 SqlVirtualMachineInstances = new[]
 *                 {
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2",
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm3",
 *                 },
 *             },
 *         },
 *         Port = 1433,
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineGroupName = "testvmgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewAvailabilityGroupListener(ctx, "availabilityGroupListener", &sqlvirtualmachine.AvailabilityGroupListenerArgs{
 * 			AvailabilityGroupListenerName: pulumi.String("agl-test"),
 * 			AvailabilityGroupName:         pulumi.String("ag-test"),
 * 			LoadBalancerConfigurations: sqlvirtualmachine.LoadBalancerConfigurationArray{
 * 				&sqlvirtualmachine.LoadBalancerConfigurationArgs{
 * 					LoadBalancerResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb-test"),
 * 					PrivateIpAddress: &sqlvirtualmachine.PrivateIPAddressArgs{
 * 						IpAddress:        pulumi.String("10.1.0.112"),
 * 						SubnetResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 					},
 * 					ProbePort: pulumi.Int(59983),
 * 					SqlVirtualMachineInstances: pulumi.StringArray{
 * 						pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2"),
 * 						pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm3"),
 * 					},
 * 				},
 * 			},
 * 			Port:                       pulumi.Int(1433),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			SqlVirtualMachineGroupName: pulumi.String("testvmgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.LoadBalancerConfigurationArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilityGroupListener = new AvailabilityGroupListener("availabilityGroupListener", AvailabilityGroupListenerArgs.builder()
 *             .availabilityGroupListenerName("agl-test")
 *             .availabilityGroupName("ag-test")
 *             .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                 .loadBalancerResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb-test")
 *                 .privateIpAddress(PrivateIPAddressArgs.builder()
 *                     .ipAddress("10.1.0.112")
 *                     .subnetResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default")
 *                     .build())
 *                 .probePort(59983)
 *                 .sqlVirtualMachineInstances(
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2",
 *                     "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm3")
 *                 .build())
 *             .port(1433)
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineGroupName("testvmgroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an availability group listener. This is used for VMs present in multi subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilityGroupListener = new AzureNative.SqlVirtualMachine.AvailabilityGroupListener("availabilityGroupListener", new()
 *     {
 *         AvailabilityGroupListenerName = "agl-test",
 *         AvailabilityGroupName = "ag-test",
 *         MultiSubnetIpConfigurations = new[]
 *         {
 *             new AzureNative.SqlVirtualMachine.Inputs.MultiSubnetIpConfigurationArgs
 *             {
 *                 PrivateIpAddress = new AzureNative.SqlVirtualMachine.Inputs.PrivateIPAddressArgs
 *                 {
 *                     IpAddress = "10.0.0.112",
 *                     SubnetResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *                 },
 *                 SqlVirtualMachineInstance = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2",
 *             },
 *             new AzureNative.SqlVirtualMachine.Inputs.MultiSubnetIpConfigurationArgs
 *             {
 *                 PrivateIpAddress = new AzureNative.SqlVirtualMachine.Inputs.PrivateIPAddressArgs
 *                 {
 *                     IpAddress = "10.0.1.112",
 *                     SubnetResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/alternate",
 *                 },
 *                 SqlVirtualMachineInstance = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm1",
 *             },
 *         },
 *         Port = 1433,
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineGroupName = "testvmgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewAvailabilityGroupListener(ctx, "availabilityGroupListener", &sqlvirtualmachine.AvailabilityGroupListenerArgs{
 * 			AvailabilityGroupListenerName: pulumi.String("agl-test"),
 * 			AvailabilityGroupName:         pulumi.String("ag-test"),
 * 			MultiSubnetIpConfigurations: sqlvirtualmachine.MultiSubnetIpConfigurationArray{
 * 				&sqlvirtualmachine.MultiSubnetIpConfigurationArgs{
 * 					PrivateIpAddress: &sqlvirtualmachine.PrivateIPAddressArgs{
 * 						IpAddress:        pulumi.String("10.0.0.112"),
 * 						SubnetResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 					},
 * 					SqlVirtualMachineInstance: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2"),
 * 				},
 * 				&sqlvirtualmachine.MultiSubnetIpConfigurationArgs{
 * 					PrivateIpAddress: &sqlvirtualmachine.PrivateIPAddressArgs{
 * 						IpAddress:        pulumi.String("10.0.1.112"),
 * 						SubnetResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/alternate"),
 * 					},
 * 					SqlVirtualMachineInstance: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm1"),
 * 				},
 * 			},
 * 			Port:                       pulumi.Int(1433),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			SqlVirtualMachineGroupName: pulumi.String("testvmgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListener;
 * import com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.MultiSubnetIpConfigurationArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilityGroupListener = new AvailabilityGroupListener("availabilityGroupListener", AvailabilityGroupListenerArgs.builder()
 *             .availabilityGroupListenerName("agl-test")
 *             .availabilityGroupName("ag-test")
 *             .multiSubnetIpConfigurations(
 *                 MultiSubnetIpConfigurationArgs.builder()
 *                     .privateIpAddress(PrivateIPAddressArgs.builder()
 *                         .ipAddress("10.0.0.112")
 *                         .subnetResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default")
 *                         .build())
 *                     .sqlVirtualMachineInstance("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm2")
 *                     .build(),
 *                 MultiSubnetIpConfigurationArgs.builder()
 *                     .privateIpAddress(PrivateIPAddressArgs.builder()
 *                         .ipAddress("10.0.1.112")
 *                         .subnetResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/alternate")
 *                         .build())
 *                     .sqlVirtualMachineInstance("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/testvm1")
 *                     .build())
 *             .port(1433)
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineGroupName("testvmgroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sqlvirtualmachine:AvailabilityGroupListener agl-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/{sqlVirtualMachineGroupName}/availabilityGroupListeners/{availabilityGroupListenerName}
 * ```
 * @property availabilityGroupConfiguration Availability Group configuration.
 * @property availabilityGroupListenerName Name of the availability group listener.
 * @property availabilityGroupName Name of the availability group.
 * @property createDefaultAvailabilityGroupIfNotExist Create a default availability group if it does not exist.
 * @property loadBalancerConfigurations List of load balancer configurations for an availability group listener.
 * @property multiSubnetIpConfigurations List of multi subnet IP configurations for an AG listener.
 * @property port Listener port.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlVirtualMachineGroupName Name of the SQL virtual machine group.
 */
public data class AvailabilityGroupListenerArgs(
    public val availabilityGroupConfiguration: Output<AgConfigurationArgs>? = null,
    public val availabilityGroupListenerName: Output<String>? = null,
    public val availabilityGroupName: Output<String>? = null,
    public val createDefaultAvailabilityGroupIfNotExist: Output<Boolean>? = null,
    public val loadBalancerConfigurations: Output<List<LoadBalancerConfigurationArgs>>? = null,
    public val multiSubnetIpConfigurations: Output<List<MultiSubnetIpConfigurationArgs>>? = null,
    public val port: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlVirtualMachineGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs =
        com.pulumi.azurenative.sqlvirtualmachine.AvailabilityGroupListenerArgs.builder()
            .availabilityGroupConfiguration(
                availabilityGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .availabilityGroupListenerName(availabilityGroupListenerName?.applyValue({ args0 -> args0 }))
            .availabilityGroupName(availabilityGroupName?.applyValue({ args0 -> args0 }))
            .createDefaultAvailabilityGroupIfNotExist(
                createDefaultAvailabilityGroupIfNotExist?.applyValue({ args0 ->
                    args0
                }),
            )
            .loadBalancerConfigurations(
                loadBalancerConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .multiSubnetIpConfigurations(
                multiSubnetIpConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlVirtualMachineGroupName(sqlVirtualMachineGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvailabilityGroupListenerArgs].
 */
@PulumiTagMarker
public class AvailabilityGroupListenerArgsBuilder internal constructor() {
    private var availabilityGroupConfiguration: Output<AgConfigurationArgs>? = null

    private var availabilityGroupListenerName: Output<String>? = null

    private var availabilityGroupName: Output<String>? = null

    private var createDefaultAvailabilityGroupIfNotExist: Output<Boolean>? = null

    private var loadBalancerConfigurations: Output<List<LoadBalancerConfigurationArgs>>? = null

    private var multiSubnetIpConfigurations: Output<List<MultiSubnetIpConfigurationArgs>>? = null

    private var port: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlVirtualMachineGroupName: Output<String>? = null

    /**
     * @param value Availability Group configuration.
     */
    @JvmName("adeewqiydedqkdym")
    public suspend fun availabilityGroupConfiguration(`value`: Output<AgConfigurationArgs>) {
        this.availabilityGroupConfiguration = value
    }

    /**
     * @param value Name of the availability group listener.
     */
    @JvmName("vdnvnqlvvjwnjngu")
    public suspend fun availabilityGroupListenerName(`value`: Output<String>) {
        this.availabilityGroupListenerName = value
    }

    /**
     * @param value Name of the availability group.
     */
    @JvmName("krhheurecnyqenjo")
    public suspend fun availabilityGroupName(`value`: Output<String>) {
        this.availabilityGroupName = value
    }

    /**
     * @param value Create a default availability group if it does not exist.
     */
    @JvmName("jmpntkbkdkelwygr")
    public suspend fun createDefaultAvailabilityGroupIfNotExist(`value`: Output<Boolean>) {
        this.createDefaultAvailabilityGroupIfNotExist = value
    }

    /**
     * @param value List of load balancer configurations for an availability group listener.
     */
    @JvmName("uljsjkgcprqkoiwb")
    public suspend fun loadBalancerConfigurations(`value`: Output<List<LoadBalancerConfigurationArgs>>) {
        this.loadBalancerConfigurations = value
    }

    @JvmName("hfythhbiiqywrebg")
    public suspend fun loadBalancerConfigurations(vararg values: Output<LoadBalancerConfigurationArgs>) {
        this.loadBalancerConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of load balancer configurations for an availability group listener.
     */
    @JvmName("hrepwddctekxgmor")
    public suspend fun loadBalancerConfigurations(values: List<Output<LoadBalancerConfigurationArgs>>) {
        this.loadBalancerConfigurations = Output.all(values)
    }

    /**
     * @param value List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("pvvvghaopcachgvq")
    public suspend fun multiSubnetIpConfigurations(`value`: Output<List<MultiSubnetIpConfigurationArgs>>) {
        this.multiSubnetIpConfigurations = value
    }

    @JvmName("abjqianksfvnrhqa")
    public suspend fun multiSubnetIpConfigurations(vararg values: Output<MultiSubnetIpConfigurationArgs>) {
        this.multiSubnetIpConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("qpuvhfegysxjpjwu")
    public suspend fun multiSubnetIpConfigurations(values: List<Output<MultiSubnetIpConfigurationArgs>>) {
        this.multiSubnetIpConfigurations = Output.all(values)
    }

    /**
     * @param value Listener port.
     */
    @JvmName("ytwiuqqbovcgfrvp")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kupedjqvdqwingbo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SQL virtual machine group.
     */
    @JvmName("arwgcmgrojvaoecr")
    public suspend fun sqlVirtualMachineGroupName(`value`: Output<String>) {
        this.sqlVirtualMachineGroupName = value
    }

    /**
     * @param value Availability Group configuration.
     */
    @JvmName("crgcbfaolwyfowmr")
    public suspend fun availabilityGroupConfiguration(`value`: AgConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityGroupConfiguration = mapped
    }

    /**
     * @param argument Availability Group configuration.
     */
    @JvmName("gjarssubxpukwvkk")
    public suspend fun availabilityGroupConfiguration(argument: suspend AgConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AgConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.availabilityGroupConfiguration = mapped
    }

    /**
     * @param value Name of the availability group listener.
     */
    @JvmName("vmdqscxjqpmytpdt")
    public suspend fun availabilityGroupListenerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityGroupListenerName = mapped
    }

    /**
     * @param value Name of the availability group.
     */
    @JvmName("oaqeauqvefllkdcl")
    public suspend fun availabilityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityGroupName = mapped
    }

    /**
     * @param value Create a default availability group if it does not exist.
     */
    @JvmName("whuckextdjivmpvc")
    public suspend fun createDefaultAvailabilityGroupIfNotExist(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createDefaultAvailabilityGroupIfNotExist = mapped
    }

    /**
     * @param value List of load balancer configurations for an availability group listener.
     */
    @JvmName("mijqlfhcjyhbvihm")
    public suspend fun loadBalancerConfigurations(`value`: List<LoadBalancerConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param argument List of load balancer configurations for an availability group listener.
     */
    @JvmName("qspwwvsayunoymts")
    public suspend fun loadBalancerConfigurations(argument: List<suspend LoadBalancerConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param argument List of load balancer configurations for an availability group listener.
     */
    @JvmName("tmwhyanlrnmkgxtu")
    public suspend fun loadBalancerConfigurations(vararg argument: suspend LoadBalancerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancerConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param argument List of load balancer configurations for an availability group listener.
     */
    @JvmName("qelcosbxkggbvplq")
    public suspend fun loadBalancerConfigurations(argument: suspend LoadBalancerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param values List of load balancer configurations for an availability group listener.
     */
    @JvmName("dwjvbnmjeoyypima")
    public suspend fun loadBalancerConfigurations(vararg values: LoadBalancerConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param value List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("iwvrnrcaeqnwvewq")
    public suspend fun multiSubnetIpConfigurations(`value`: List<MultiSubnetIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiSubnetIpConfigurations = mapped
    }

    /**
     * @param argument List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("wybsqfqnesvnylqx")
    public suspend fun multiSubnetIpConfigurations(argument: List<suspend MultiSubnetIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MultiSubnetIpConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.multiSubnetIpConfigurations = mapped
    }

    /**
     * @param argument List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("bxkjtuunmxktsfdb")
    public suspend fun multiSubnetIpConfigurations(vararg argument: suspend MultiSubnetIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MultiSubnetIpConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.multiSubnetIpConfigurations = mapped
    }

    /**
     * @param argument List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("soyuvidufhqujyit")
    public suspend fun multiSubnetIpConfigurations(argument: suspend MultiSubnetIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MultiSubnetIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.multiSubnetIpConfigurations = mapped
    }

    /**
     * @param values List of multi subnet IP configurations for an AG listener.
     */
    @JvmName("gwocixfqucqbkbis")
    public suspend fun multiSubnetIpConfigurations(vararg values: MultiSubnetIpConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiSubnetIpConfigurations = mapped
    }

    /**
     * @param value Listener port.
     */
    @JvmName("wlvihbmhwoswjcek")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("eluldplmyafsyfkq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL virtual machine group.
     */
    @JvmName("wgxubrwmspjaimfb")
    public suspend fun sqlVirtualMachineGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVirtualMachineGroupName = mapped
    }

    internal fun build(): AvailabilityGroupListenerArgs = AvailabilityGroupListenerArgs(
        availabilityGroupConfiguration = availabilityGroupConfiguration,
        availabilityGroupListenerName = availabilityGroupListenerName,
        availabilityGroupName = availabilityGroupName,
        createDefaultAvailabilityGroupIfNotExist = createDefaultAvailabilityGroupIfNotExist,
        loadBalancerConfigurations = loadBalancerConfigurations,
        multiSubnetIpConfigurations = multiSubnetIpConfigurations,
        port = port,
        resourceGroupName = resourceGroupName,
        sqlVirtualMachineGroupName = sqlVirtualMachineGroupName,
    )
}
