@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.SqlvirtualmachineFunctions.getAvailabilityGroupListenerPlain
import com.pulumi.azurenative.sqlvirtualmachine.SqlvirtualmachineFunctions.getSqlVirtualMachineGroupPlain
import com.pulumi.azurenative.sqlvirtualmachine.SqlvirtualmachineFunctions.getSqlVirtualMachinePlain
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.GetAvailabilityGroupListenerPlainArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.GetAvailabilityGroupListenerPlainArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.GetSqlVirtualMachineGroupPlainArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.GetSqlVirtualMachineGroupPlainArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.GetSqlVirtualMachinePlainArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.GetSqlVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.GetAvailabilityGroupListenerResult
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.GetSqlVirtualMachineGroupResult
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.GetSqlVirtualMachineResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.GetAvailabilityGroupListenerResult.Companion.toKotlin as getAvailabilityGroupListenerResultToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.GetSqlVirtualMachineGroupResult.Companion.toKotlin as getSqlVirtualMachineGroupResultToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.GetSqlVirtualMachineResult.Companion.toKotlin as getSqlVirtualMachineResultToKotlin

public object SqlvirtualmachineFunctions {
    /**
     * Gets an availability group listener.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2023-01-01-preview, 2023-10-01.
     * @param argument null
     * @return A SQL Server availability group listener.
     */
    public suspend fun getAvailabilityGroupListener(argument: GetAvailabilityGroupListenerPlainArgs): GetAvailabilityGroupListenerResult =
        getAvailabilityGroupListenerResultToKotlin(getAvailabilityGroupListenerPlain(argument.toJava()).await())

    /**
     * @see [getAvailabilityGroupListener].
     * @param availabilityGroupListenerName Name of the availability group listener.
     * @param expand The child resources to include in the response.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlVirtualMachineGroupName Name of the SQL virtual machine group.
     * @return A SQL Server availability group listener.
     */
    public suspend fun getAvailabilityGroupListener(
        availabilityGroupListenerName: String,
        expand: String? = null,
        resourceGroupName: String,
        sqlVirtualMachineGroupName: String,
    ): GetAvailabilityGroupListenerResult {
        val argument = GetAvailabilityGroupListenerPlainArgs(
            availabilityGroupListenerName = availabilityGroupListenerName,
            expand = expand,
            resourceGroupName = resourceGroupName,
            sqlVirtualMachineGroupName = sqlVirtualMachineGroupName,
        )
        return getAvailabilityGroupListenerResultToKotlin(getAvailabilityGroupListenerPlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilityGroupListener].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sqlvirtualmachine&#46;kotlin&#46;inputs&#46;GetAvailabilityGroupListenerPlainArgs].
     * @return A SQL Server availability group listener.
     */
    public suspend fun getAvailabilityGroupListener(argument: suspend GetAvailabilityGroupListenerPlainArgsBuilder.() -> Unit): GetAvailabilityGroupListenerResult {
        val builder = GetAvailabilityGroupListenerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilityGroupListenerResultToKotlin(getAvailabilityGroupListenerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a SQL virtual machine.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2023-01-01-preview, 2023-10-01.
     * @param argument null
     * @return A SQL virtual machine.
     */
    public suspend fun getSqlVirtualMachine(argument: GetSqlVirtualMachinePlainArgs): GetSqlVirtualMachineResult =
        getSqlVirtualMachineResultToKotlin(getSqlVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getSqlVirtualMachine].
     * @param expand The child resources to include in the response.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlVirtualMachineName Name of the SQL virtual machine.
     * @return A SQL virtual machine.
     */
    public suspend fun getSqlVirtualMachine(
        expand: String? = null,
        resourceGroupName: String,
        sqlVirtualMachineName: String,
    ): GetSqlVirtualMachineResult {
        val argument = GetSqlVirtualMachinePlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            sqlVirtualMachineName = sqlVirtualMachineName,
        )
        return getSqlVirtualMachineResultToKotlin(getSqlVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sqlvirtualmachine&#46;kotlin&#46;inputs&#46;GetSqlVirtualMachinePlainArgs].
     * @return A SQL virtual machine.
     */
    public suspend fun getSqlVirtualMachine(argument: suspend GetSqlVirtualMachinePlainArgsBuilder.() -> Unit): GetSqlVirtualMachineResult {
        val builder = GetSqlVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlVirtualMachineResultToKotlin(getSqlVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a SQL virtual machine group.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2023-01-01-preview, 2023-10-01.
     * @param argument null
     * @return A SQL virtual machine group.
     */
    public suspend fun getSqlVirtualMachineGroup(argument: GetSqlVirtualMachineGroupPlainArgs): GetSqlVirtualMachineGroupResult =
        getSqlVirtualMachineGroupResultToKotlin(getSqlVirtualMachineGroupPlain(argument.toJava()).await())

    /**
     * @see [getSqlVirtualMachineGroup].
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlVirtualMachineGroupName Name of the SQL virtual machine group.
     * @return A SQL virtual machine group.
     */
    public suspend fun getSqlVirtualMachineGroup(
        resourceGroupName: String,
        sqlVirtualMachineGroupName: String,
    ): GetSqlVirtualMachineGroupResult {
        val argument = GetSqlVirtualMachineGroupPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlVirtualMachineGroupName = sqlVirtualMachineGroupName,
        )
        return getSqlVirtualMachineGroupResultToKotlin(getSqlVirtualMachineGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlVirtualMachineGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sqlvirtualmachine&#46;kotlin&#46;inputs&#46;GetSqlVirtualMachineGroupPlainArgs].
     * @return A SQL virtual machine group.
     */
    public suspend fun getSqlVirtualMachineGroup(argument: suspend GetSqlVirtualMachineGroupPlainArgsBuilder.() -> Unit): GetSqlVirtualMachineGroupResult {
        val builder = GetSqlVirtualMachineGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlVirtualMachineGroupResultToKotlin(getSqlVirtualMachineGroupPlain(builtArgument.toJava()).await())
    }
}
