@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
 */
public enum class FullBackupFrequencyType(
    public val javaValue: com.pulumi.azurenative.sqlvirtualmachine.enums.FullBackupFrequencyType,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.enums.FullBackupFrequencyType> {
    Daily(com.pulumi.azurenative.sqlvirtualmachine.enums.FullBackupFrequencyType.Daily),
    Weekly(com.pulumi.azurenative.sqlvirtualmachine.enums.FullBackupFrequencyType.Weekly),
    ;

    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.enums.FullBackupFrequencyType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.enums.FullBackupFrequencyType): FullBackupFrequencyType =
            FullBackupFrequencyType.values().first { it.javaValue == javaType }
    }
}
