@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.AssessmentSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configure assessment for databases in your SQL virtual machine.
 * @property enable Enable or disable assessment feature on SQL virtual machine.
 * @property runImmediately Run assessment immediately on SQL virtual machine.
 * @property schedule Schedule for Assessment.
 */
public data class AssessmentSettingsArgs(
    public val enable: Output<Boolean>? = null,
    public val runImmediately: Output<Boolean>? = null,
    public val schedule: Output<ScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.AssessmentSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.AssessmentSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AssessmentSettingsArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .runImmediately(runImmediately?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AssessmentSettingsArgs].
 */
@PulumiTagMarker
public class AssessmentSettingsArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var runImmediately: Output<Boolean>? = null

    private var schedule: Output<ScheduleArgs>? = null

    /**
     * @param value Enable or disable assessment feature on SQL virtual machine.
     */
    @JvmName("jnmvfodncjpxkdhf")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Run assessment immediately on SQL virtual machine.
     */
    @JvmName("hxrvccrigusjaesw")
    public suspend fun runImmediately(`value`: Output<Boolean>) {
        this.runImmediately = value
    }

    /**
     * @param value Schedule for Assessment.
     */
    @JvmName("taawltiarfeaufnu")
    public suspend fun schedule(`value`: Output<ScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Enable or disable assessment feature on SQL virtual machine.
     */
    @JvmName("vyywbpvknlarisbq")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Run assessment immediately on SQL virtual machine.
     */
    @JvmName("qbhirwvojgitgkcd")
    public suspend fun runImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runImmediately = mapped
    }

    /**
     * @param value Schedule for Assessment.
     */
    @JvmName("qubdrgdudxbcebxf")
    public suspend fun schedule(`value`: ScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Schedule for Assessment.
     */
    @JvmName("vjfigavortdiutwb")
    public suspend fun schedule(argument: suspend ScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): AssessmentSettingsArgs = AssessmentSettingsArgs(
        enable = enable,
        runImmediately = runImmediately,
        schedule = schedule,
    )
}
