@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoBackupSettingsArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.AutoBackupDaysOfWeek
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.BackupScheduleType
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.FullBackupFrequencyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configure backups for databases in your SQL virtual machine.
 * @property backupScheduleType Backup schedule type.
 * @property backupSystemDbs Include or exclude system databases from auto backup.
 * @property daysOfWeek Days of the week for the backups when FullBackupFrequency is set to Weekly.
 * @property enable Enable or disable autobackup on SQL virtual machine.
 * @property enableEncryption Enable or disable encryption for backup on SQL virtual machine.
 * @property fullBackupFrequency Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
 * @property fullBackupStartTime Start time of a given day during which full backups can take place. 0-23 hours.
 * @property fullBackupWindowHours Duration of the time window of a given day during which full backups can take place. 1-23 hours.
 * @property logBackupFrequency Frequency of log backups. 5-60 minutes.
 * @property password Password for encryption on backup.
 * @property retentionPeriod Retention period of backup: 1-90 days.
 * @property storageAccessKey Storage account key where backup will be taken to.
 * @property storageAccountUrl Storage account url where backup will be taken to.
 * @property storageContainerName Storage container name where backup will be taken to.
 */
public data class AutoBackupSettingsArgs(
    public val backupScheduleType: Output<Either<String, BackupScheduleType>>? = null,
    public val backupSystemDbs: Output<Boolean>? = null,
    public val daysOfWeek: Output<List<Either<String, AutoBackupDaysOfWeek>>>? = null,
    public val enable: Output<Boolean>? = null,
    public val enableEncryption: Output<Boolean>? = null,
    public val fullBackupFrequency: Output<Either<String, FullBackupFrequencyType>>? = null,
    public val fullBackupStartTime: Output<Int>? = null,
    public val fullBackupWindowHours: Output<Int>? = null,
    public val logBackupFrequency: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val retentionPeriod: Output<Int>? = null,
    public val storageAccessKey: Output<String>? = null,
    public val storageAccountUrl: Output<String>? = null,
    public val storageContainerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoBackupSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoBackupSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoBackupSettingsArgs.builder()
            .backupScheduleType(
                backupScheduleType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .backupSystemDbs(backupSystemDbs?.applyValue({ args0 -> args0 }))
            .daysOfWeek(
                daysOfWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .enable(enable?.applyValue({ args0 -> args0 }))
            .enableEncryption(enableEncryption?.applyValue({ args0 -> args0 }))
            .fullBackupFrequency(
                fullBackupFrequency?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .fullBackupStartTime(fullBackupStartTime?.applyValue({ args0 -> args0 }))
            .fullBackupWindowHours(fullBackupWindowHours?.applyValue({ args0 -> args0 }))
            .logBackupFrequency(logBackupFrequency?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .storageAccessKey(storageAccessKey?.applyValue({ args0 -> args0 }))
            .storageAccountUrl(storageAccountUrl?.applyValue({ args0 -> args0 }))
            .storageContainerName(storageContainerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoBackupSettingsArgs].
 */
@PulumiTagMarker
public class AutoBackupSettingsArgsBuilder internal constructor() {
    private var backupScheduleType: Output<Either<String, BackupScheduleType>>? = null

    private var backupSystemDbs: Output<Boolean>? = null

    private var daysOfWeek: Output<List<Either<String, AutoBackupDaysOfWeek>>>? = null

    private var enable: Output<Boolean>? = null

    private var enableEncryption: Output<Boolean>? = null

    private var fullBackupFrequency: Output<Either<String, FullBackupFrequencyType>>? = null

    private var fullBackupStartTime: Output<Int>? = null

    private var fullBackupWindowHours: Output<Int>? = null

    private var logBackupFrequency: Output<Int>? = null

    private var password: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    private var storageAccessKey: Output<String>? = null

    private var storageAccountUrl: Output<String>? = null

    private var storageContainerName: Output<String>? = null

    /**
     * @param value Backup schedule type.
     */
    @JvmName("wxpwivfcpjccmjij")
    public suspend fun backupScheduleType(`value`: Output<Either<String, BackupScheduleType>>) {
        this.backupScheduleType = value
    }

    /**
     * @param value Include or exclude system databases from auto backup.
     */
    @JvmName("aufnjdnivsyopftm")
    public suspend fun backupSystemDbs(`value`: Output<Boolean>) {
        this.backupSystemDbs = value
    }

    /**
     * @param value Days of the week for the backups when FullBackupFrequency is set to Weekly.
     */
    @JvmName("fecyisliwuclbwlv")
    public suspend fun daysOfWeek(`value`: Output<List<Either<String, AutoBackupDaysOfWeek>>>) {
        this.daysOfWeek = value
    }

    @JvmName("ifwbgfjykhuebexf")
    public suspend fun daysOfWeek(vararg values: Output<Either<String, AutoBackupDaysOfWeek>>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Days of the week for the backups when FullBackupFrequency is set to Weekly.
     */
    @JvmName("ovlptgfskeyrxxks")
    public suspend fun daysOfWeek(values: List<Output<Either<String, AutoBackupDaysOfWeek>>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value Enable or disable autobackup on SQL virtual machine.
     */
    @JvmName("ywbxfripfgoxtdre")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Enable or disable encryption for backup on SQL virtual machine.
     */
    @JvmName("qnbwqspxeptgmprh")
    public suspend fun enableEncryption(`value`: Output<Boolean>) {
        this.enableEncryption = value
    }

    /**
     * @param value Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
     */
    @JvmName("vhdpwxeybhjrcybk")
    public suspend fun fullBackupFrequency(`value`: Output<Either<String, FullBackupFrequencyType>>) {
        this.fullBackupFrequency = value
    }

    /**
     * @param value Start time of a given day during which full backups can take place. 0-23 hours.
     */
    @JvmName("jcmmweanancpiguv")
    public suspend fun fullBackupStartTime(`value`: Output<Int>) {
        this.fullBackupStartTime = value
    }

    /**
     * @param value Duration of the time window of a given day during which full backups can take place. 1-23 hours.
     */
    @JvmName("bwwqtvqesxdangjd")
    public suspend fun fullBackupWindowHours(`value`: Output<Int>) {
        this.fullBackupWindowHours = value
    }

    /**
     * @param value Frequency of log backups. 5-60 minutes.
     */
    @JvmName("tlniesjltljphcll")
    public suspend fun logBackupFrequency(`value`: Output<Int>) {
        this.logBackupFrequency = value
    }

    /**
     * @param value Password for encryption on backup.
     */
    @JvmName("hppjivpyewhswgub")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Retention period of backup: 1-90 days.
     */
    @JvmName("poufwveliulrvfiq")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Storage account key where backup will be taken to.
     */
    @JvmName("ftprlddmlrchsnkn")
    public suspend fun storageAccessKey(`value`: Output<String>) {
        this.storageAccessKey = value
    }

    /**
     * @param value Storage account url where backup will be taken to.
     */
    @JvmName("scksgfvrlavjkawq")
    public suspend fun storageAccountUrl(`value`: Output<String>) {
        this.storageAccountUrl = value
    }

    /**
     * @param value Storage container name where backup will be taken to.
     */
    @JvmName("iugliqpfsvxwbiap")
    public suspend fun storageContainerName(`value`: Output<String>) {
        this.storageContainerName = value
    }

    /**
     * @param value Backup schedule type.
     */
    @JvmName("vvdigxuucaktbcti")
    public suspend fun backupScheduleType(`value`: Either<String, BackupScheduleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupScheduleType = mapped
    }

    /**
     * @param value Backup schedule type.
     */
    @JvmName("xcvpedmfpogpcsqw")
    public fun backupScheduleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupScheduleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupScheduleType = mapped
    }

    /**
     * @param value Backup schedule type.
     */
    @JvmName("hhfcaieloicttjke")
    public fun backupScheduleType(`value`: BackupScheduleType) {
        val toBeMapped = Either.ofRight<String, BackupScheduleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupScheduleType = mapped
    }

    /**
     * @param value Include or exclude system databases from auto backup.
     */
    @JvmName("jilpxvgrsvyxfvga")
    public suspend fun backupSystemDbs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSystemDbs = mapped
    }

    /**
     * @param value Days of the week for the backups when FullBackupFrequency is set to Weekly.
     */
    @JvmName("fokwvkjtrnsmqmot")
    public suspend fun daysOfWeek(`value`: List<Either<String, AutoBackupDaysOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Days of the week for the backups when FullBackupFrequency is set to Weekly.
     */
    @JvmName("bqycghivhpbimqky")
    public suspend fun daysOfWeek(vararg values: Either<String, AutoBackupDaysOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value Enable or disable autobackup on SQL virtual machine.
     */
    @JvmName("ctcnckevtwoyicvu")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Enable or disable encryption for backup on SQL virtual machine.
     */
    @JvmName("oyghrhcsgwtswmnb")
    public suspend fun enableEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEncryption = mapped
    }

    /**
     * @param value Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
     */
    @JvmName("bdvdpdiesilncahn")
    public suspend fun fullBackupFrequency(`value`: Either<String, FullBackupFrequencyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullBackupFrequency = mapped
    }

    /**
     * @param value Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
     */
    @JvmName("krdcwjoqhdculfks")
    public fun fullBackupFrequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FullBackupFrequencyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fullBackupFrequency = mapped
    }

    /**
     * @param value Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
     */
    @JvmName("tuvxismyjkcnbmbj")
    public fun fullBackupFrequency(`value`: FullBackupFrequencyType) {
        val toBeMapped = Either.ofRight<String, FullBackupFrequencyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fullBackupFrequency = mapped
    }

    /**
     * @param value Start time of a given day during which full backups can take place. 0-23 hours.
     */
    @JvmName("wqiwocysuukpjgmu")
    public suspend fun fullBackupStartTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullBackupStartTime = mapped
    }

    /**
     * @param value Duration of the time window of a given day during which full backups can take place. 1-23 hours.
     */
    @JvmName("icetilydcasabalv")
    public suspend fun fullBackupWindowHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullBackupWindowHours = mapped
    }

    /**
     * @param value Frequency of log backups. 5-60 minutes.
     */
    @JvmName("mqsuduntbwdpvrlc")
    public suspend fun logBackupFrequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackupFrequency = mapped
    }

    /**
     * @param value Password for encryption on backup.
     */
    @JvmName("vbfdjblrqstyqbhp")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Retention period of backup: 1-90 days.
     */
    @JvmName("vufrgvxontkkjnbo")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value Storage account key where backup will be taken to.
     */
    @JvmName("fsqygnjfafextbnx")
    public suspend fun storageAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccessKey = mapped
    }

    /**
     * @param value Storage account url where backup will be taken to.
     */
    @JvmName("nkdnwdmowqgekpnx")
    public suspend fun storageAccountUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountUrl = mapped
    }

    /**
     * @param value Storage container name where backup will be taken to.
     */
    @JvmName("chdamidchykjvave")
    public suspend fun storageContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerName = mapped
    }

    internal fun build(): AutoBackupSettingsArgs = AutoBackupSettingsArgs(
        backupScheduleType = backupScheduleType,
        backupSystemDbs = backupSystemDbs,
        daysOfWeek = daysOfWeek,
        enable = enable,
        enableEncryption = enableEncryption,
        fullBackupFrequency = fullBackupFrequency,
        fullBackupStartTime = fullBackupStartTime,
        fullBackupWindowHours = fullBackupWindowHours,
        logBackupFrequency = logBackupFrequency,
        password = password,
        retentionPeriod = retentionPeriod,
        storageAccessKey = storageAccessKey,
        storageAccountUrl = storageAccountUrl,
        storageContainerName = storageContainerName,
    )
}
