@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.KeyVaultCredentialSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.
 * @property azureKeyVaultUrl Azure Key Vault url.
 * @property credentialName Credential name.
 * @property enable Enable or disable key vault credential setting.
 * @property servicePrincipalName Service principal name to access key vault.
 * @property servicePrincipalSecret Service principal name secret to access key vault.
 */
public data class KeyVaultCredentialSettingsArgs(
    public val azureKeyVaultUrl: Output<String>? = null,
    public val credentialName: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val servicePrincipalName: Output<String>? = null,
    public val servicePrincipalSecret: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.KeyVaultCredentialSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.KeyVaultCredentialSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.KeyVaultCredentialSettingsArgs.builder()
            .azureKeyVaultUrl(azureKeyVaultUrl?.applyValue({ args0 -> args0 }))
            .credentialName(credentialName?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .servicePrincipalName(servicePrincipalName?.applyValue({ args0 -> args0 }))
            .servicePrincipalSecret(servicePrincipalSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultCredentialSettingsArgs].
 */
@PulumiTagMarker
public class KeyVaultCredentialSettingsArgsBuilder internal constructor() {
    private var azureKeyVaultUrl: Output<String>? = null

    private var credentialName: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var servicePrincipalName: Output<String>? = null

    private var servicePrincipalSecret: Output<String>? = null

    /**
     * @param value Azure Key Vault url.
     */
    @JvmName("whodupungsjxjaqf")
    public suspend fun azureKeyVaultUrl(`value`: Output<String>) {
        this.azureKeyVaultUrl = value
    }

    /**
     * @param value Credential name.
     */
    @JvmName("ynjnyymaqrplwxgu")
    public suspend fun credentialName(`value`: Output<String>) {
        this.credentialName = value
    }

    /**
     * @param value Enable or disable key vault credential setting.
     */
    @JvmName("ytxkxnqfkroxlneq")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Service principal name to access key vault.
     */
    @JvmName("umfrneqeesbynyot")
    public suspend fun servicePrincipalName(`value`: Output<String>) {
        this.servicePrincipalName = value
    }

    /**
     * @param value Service principal name secret to access key vault.
     */
    @JvmName("yfdowobohtrnpotn")
    public suspend fun servicePrincipalSecret(`value`: Output<String>) {
        this.servicePrincipalSecret = value
    }

    /**
     * @param value Azure Key Vault url.
     */
    @JvmName("plabdowafrdinkdl")
    public suspend fun azureKeyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureKeyVaultUrl = mapped
    }

    /**
     * @param value Credential name.
     */
    @JvmName("ltvcpccnaswuyycm")
    public suspend fun credentialName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialName = mapped
    }

    /**
     * @param value Enable or disable key vault credential setting.
     */
    @JvmName("sibjovexuaxwdkqy")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Service principal name to access key vault.
     */
    @JvmName("jtpgrnkejcsdlisq")
    public suspend fun servicePrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalName = mapped
    }

    /**
     * @param value Service principal name secret to access key vault.
     */
    @JvmName("uattcubudewedbsj")
    public suspend fun servicePrincipalSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalSecret = mapped
    }

    internal fun build(): KeyVaultCredentialSettingsArgs = KeyVaultCredentialSettingsArgs(
        azureKeyVaultUrl = azureKeyVaultUrl,
        credentialName = credentialName,
        enable = enable,
        servicePrincipalName = servicePrincipalName,
        servicePrincipalSecret = servicePrincipalSecret,
    )
}
