@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.ServerConfigurationsManagementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Set the connectivity, storage and workload settings.
 * @property additionalFeaturesServerConfigurations Additional SQL feature settings.
 * @property sqlConnectivityUpdateSettings SQL connectivity type settings.
 * @property sqlInstanceSettings SQL Instance settings.
 * @property sqlStorageUpdateSettings SQL storage update settings.
 * @property sqlWorkloadTypeUpdateSettings SQL workload type settings.
 */
public data class ServerConfigurationsManagementSettingsArgs(
    public val additionalFeaturesServerConfigurations: Output<AdditionalFeaturesServerConfigurationsArgs>? = null,
    public val sqlConnectivityUpdateSettings: Output<SqlConnectivityUpdateSettingsArgs>? = null,
    public val sqlInstanceSettings: Output<SQLInstanceSettingsArgs>? = null,
    public val sqlStorageUpdateSettings: Output<SqlStorageUpdateSettingsArgs>? = null,
    public val sqlWorkloadTypeUpdateSettings: Output<SqlWorkloadTypeUpdateSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.ServerConfigurationsManagementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.ServerConfigurationsManagementSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.ServerConfigurationsManagementSettingsArgs.builder()
            .additionalFeaturesServerConfigurations(
                additionalFeaturesServerConfigurations?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sqlConnectivityUpdateSettings(
                sqlConnectivityUpdateSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sqlInstanceSettings(
                sqlInstanceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqlStorageUpdateSettings(
                sqlStorageUpdateSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqlWorkloadTypeUpdateSettings(
                sqlWorkloadTypeUpdateSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ServerConfigurationsManagementSettingsArgs].
 */
@PulumiTagMarker
public class ServerConfigurationsManagementSettingsArgsBuilder internal constructor() {
    private var additionalFeaturesServerConfigurations:
        Output<AdditionalFeaturesServerConfigurationsArgs>? = null

    private var sqlConnectivityUpdateSettings: Output<SqlConnectivityUpdateSettingsArgs>? = null

    private var sqlInstanceSettings: Output<SQLInstanceSettingsArgs>? = null

    private var sqlStorageUpdateSettings: Output<SqlStorageUpdateSettingsArgs>? = null

    private var sqlWorkloadTypeUpdateSettings: Output<SqlWorkloadTypeUpdateSettingsArgs>? = null

    /**
     * @param value Additional SQL feature settings.
     */
    @JvmName("oncnyucwlmtsxerh")
    public suspend fun additionalFeaturesServerConfigurations(`value`: Output<AdditionalFeaturesServerConfigurationsArgs>) {
        this.additionalFeaturesServerConfigurations = value
    }

    /**
     * @param value SQL connectivity type settings.
     */
    @JvmName("mravdllcyrtlxsov")
    public suspend fun sqlConnectivityUpdateSettings(`value`: Output<SqlConnectivityUpdateSettingsArgs>) {
        this.sqlConnectivityUpdateSettings = value
    }

    /**
     * @param value SQL Instance settings.
     */
    @JvmName("vmkdxfxohhyuwkww")
    public suspend fun sqlInstanceSettings(`value`: Output<SQLInstanceSettingsArgs>) {
        this.sqlInstanceSettings = value
    }

    /**
     * @param value SQL storage update settings.
     */
    @JvmName("tuoaxmiprsflflsf")
    public suspend fun sqlStorageUpdateSettings(`value`: Output<SqlStorageUpdateSettingsArgs>) {
        this.sqlStorageUpdateSettings = value
    }

    /**
     * @param value SQL workload type settings.
     */
    @JvmName("sgcqxbqhaoohbfky")
    public suspend fun sqlWorkloadTypeUpdateSettings(`value`: Output<SqlWorkloadTypeUpdateSettingsArgs>) {
        this.sqlWorkloadTypeUpdateSettings = value
    }

    /**
     * @param value Additional SQL feature settings.
     */
    @JvmName("rrphvyvcluivmgty")
    public suspend fun additionalFeaturesServerConfigurations(`value`: AdditionalFeaturesServerConfigurationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalFeaturesServerConfigurations = mapped
    }

    /**
     * @param argument Additional SQL feature settings.
     */
    @JvmName("bpamkxcexkfmeqwk")
    public suspend fun additionalFeaturesServerConfigurations(argument: suspend AdditionalFeaturesServerConfigurationsArgsBuilder.() -> Unit) {
        val toBeMapped = AdditionalFeaturesServerConfigurationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.additionalFeaturesServerConfigurations = mapped
    }

    /**
     * @param value SQL connectivity type settings.
     */
    @JvmName("tgndvrcwbqbhjkad")
    public suspend fun sqlConnectivityUpdateSettings(`value`: SqlConnectivityUpdateSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlConnectivityUpdateSettings = mapped
    }

    /**
     * @param argument SQL connectivity type settings.
     */
    @JvmName("msajgpxoatttmbrw")
    public suspend fun sqlConnectivityUpdateSettings(argument: suspend SqlConnectivityUpdateSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectivityUpdateSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlConnectivityUpdateSettings = mapped
    }

    /**
     * @param value SQL Instance settings.
     */
    @JvmName("obpyqtxkacuewctt")
    public suspend fun sqlInstanceSettings(`value`: SQLInstanceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlInstanceSettings = mapped
    }

    /**
     * @param argument SQL Instance settings.
     */
    @JvmName("nsytxwqcaxhmtbvi")
    public suspend fun sqlInstanceSettings(argument: suspend SQLInstanceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SQLInstanceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlInstanceSettings = mapped
    }

    /**
     * @param value SQL storage update settings.
     */
    @JvmName("sowovycxhyachkmu")
    public suspend fun sqlStorageUpdateSettings(`value`: SqlStorageUpdateSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlStorageUpdateSettings = mapped
    }

    /**
     * @param argument SQL storage update settings.
     */
    @JvmName("dsaelcmkprkmpojx")
    public suspend fun sqlStorageUpdateSettings(argument: suspend SqlStorageUpdateSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlStorageUpdateSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlStorageUpdateSettings = mapped
    }

    /**
     * @param value SQL workload type settings.
     */
    @JvmName("xphwsujffgembuyb")
    public suspend fun sqlWorkloadTypeUpdateSettings(`value`: SqlWorkloadTypeUpdateSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlWorkloadTypeUpdateSettings = mapped
    }

    /**
     * @param argument SQL workload type settings.
     */
    @JvmName("fvxdcktevprsbxga")
    public suspend fun sqlWorkloadTypeUpdateSettings(argument: suspend SqlWorkloadTypeUpdateSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlWorkloadTypeUpdateSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlWorkloadTypeUpdateSettings = mapped
    }

    internal fun build(): ServerConfigurationsManagementSettingsArgs =
        ServerConfigurationsManagementSettingsArgs(
            additionalFeaturesServerConfigurations = additionalFeaturesServerConfigurations,
            sqlConnectivityUpdateSettings = sqlConnectivityUpdateSettings,
            sqlInstanceSettings = sqlInstanceSettings,
            sqlStorageUpdateSettings = sqlStorageUpdateSettings,
            sqlWorkloadTypeUpdateSettings = sqlWorkloadTypeUpdateSettings,
        )
}
