@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlStorageUpdateSettingsArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.DiskConfigurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Set disk storage settings for SQL Server.
 * @property diskConfigurationType Disk configuration to apply to SQL Server.
 * @property diskCount Virtual machine disk count.
 * @property startingDeviceId Device id of the first disk to be updated.
 */
public data class SqlStorageUpdateSettingsArgs(
    public val diskConfigurationType: Output<Either<String, DiskConfigurationType>>? = null,
    public val diskCount: Output<Int>? = null,
    public val startingDeviceId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlStorageUpdateSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlStorageUpdateSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlStorageUpdateSettingsArgs.builder()
            .diskConfigurationType(
                diskConfigurationType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .diskCount(diskCount?.applyValue({ args0 -> args0 }))
            .startingDeviceId(startingDeviceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlStorageUpdateSettingsArgs].
 */
@PulumiTagMarker
public class SqlStorageUpdateSettingsArgsBuilder internal constructor() {
    private var diskConfigurationType: Output<Either<String, DiskConfigurationType>>? = null

    private var diskCount: Output<Int>? = null

    private var startingDeviceId: Output<Int>? = null

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("osvdfwldriptliho")
    public suspend fun diskConfigurationType(`value`: Output<Either<String, DiskConfigurationType>>) {
        this.diskConfigurationType = value
    }

    /**
     * @param value Virtual machine disk count.
     */
    @JvmName("dermqrpalhigugvb")
    public suspend fun diskCount(`value`: Output<Int>) {
        this.diskCount = value
    }

    /**
     * @param value Device id of the first disk to be updated.
     */
    @JvmName("uxtmvamavbubnvtn")
    public suspend fun startingDeviceId(`value`: Output<Int>) {
        this.startingDeviceId = value
    }

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("tquqmxylmncokpwr")
    public suspend fun diskConfigurationType(`value`: Either<String, DiskConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskConfigurationType = mapped
    }

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("qekvwdgyguaorcck")
    public fun diskConfigurationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskConfigurationType = mapped
    }

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("jcydwgokwhkhlcek")
    public fun diskConfigurationType(`value`: DiskConfigurationType) {
        val toBeMapped = Either.ofRight<String, DiskConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskConfigurationType = mapped
    }

    /**
     * @param value Virtual machine disk count.
     */
    @JvmName("gvmehqehrgdvmwll")
    public suspend fun diskCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCount = mapped
    }

    /**
     * @param value Device id of the first disk to be updated.
     */
    @JvmName("miagrukynmxxcymn")
    public suspend fun startingDeviceId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingDeviceId = mapped
    }

    internal fun build(): SqlStorageUpdateSettingsArgs = SqlStorageUpdateSettingsArgs(
        diskConfigurationType = diskConfigurationType,
        diskCount = diskCount,
        startingDeviceId = startingDeviceId,
    )
}
