@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
 * @property clusterBootstrapAccountPassword Cluster bootstrap account password.
 * @property clusterOperatorAccountPassword Cluster operator account password.
 * @property sqlServiceAccountPassword SQL service account password.
 */
public data class WsfcDomainCredentialsArgs(
    public val clusterBootstrapAccountPassword: Output<String>? = null,
    public val clusterOperatorAccountPassword: Output<String>? = null,
    public val sqlServiceAccountPassword: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainCredentialsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainCredentialsArgs.builder()
            .clusterBootstrapAccountPassword(clusterBootstrapAccountPassword?.applyValue({ args0 -> args0 }))
            .clusterOperatorAccountPassword(clusterOperatorAccountPassword?.applyValue({ args0 -> args0 }))
            .sqlServiceAccountPassword(sqlServiceAccountPassword?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WsfcDomainCredentialsArgs].
 */
@PulumiTagMarker
public class WsfcDomainCredentialsArgsBuilder internal constructor() {
    private var clusterBootstrapAccountPassword: Output<String>? = null

    private var clusterOperatorAccountPassword: Output<String>? = null

    private var sqlServiceAccountPassword: Output<String>? = null

    /**
     * @param value Cluster bootstrap account password.
     */
    @JvmName("mbwunjdnakimeyge")
    public suspend fun clusterBootstrapAccountPassword(`value`: Output<String>) {
        this.clusterBootstrapAccountPassword = value
    }

    /**
     * @param value Cluster operator account password.
     */
    @JvmName("lswoixcdsebgqams")
    public suspend fun clusterOperatorAccountPassword(`value`: Output<String>) {
        this.clusterOperatorAccountPassword = value
    }

    /**
     * @param value SQL service account password.
     */
    @JvmName("dtnyualjjpkuwqea")
    public suspend fun sqlServiceAccountPassword(`value`: Output<String>) {
        this.sqlServiceAccountPassword = value
    }

    /**
     * @param value Cluster bootstrap account password.
     */
    @JvmName("xjppurpymwwkifnw")
    public suspend fun clusterBootstrapAccountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterBootstrapAccountPassword = mapped
    }

    /**
     * @param value Cluster operator account password.
     */
    @JvmName("kmnehsioyqxmrtcm")
    public suspend fun clusterOperatorAccountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterOperatorAccountPassword = mapped
    }

    /**
     * @param value SQL service account password.
     */
    @JvmName("oedbcywjdijyhtxl")
    public suspend fun sqlServiceAccountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServiceAccountPassword = mapped
    }

    internal fun build(): WsfcDomainCredentialsArgs = WsfcDomainCredentialsArgs(
        clusterBootstrapAccountPassword = clusterBootstrapAccountPassword,
        clusterOperatorAccountPassword = clusterOperatorAccountPassword,
        sqlServiceAccountPassword = sqlServiceAccountPassword,
    )
}
