@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Availability group replica configuration.
 * @property commit Replica commit mode in availability group.
 * @property failover Replica failover mode in availability group.
 * @property readableSecondary Replica readable secondary mode in availability group.
 * @property role Replica Role in availability group.
 * @property sqlVirtualMachineInstanceId Sql VirtualMachine Instance Id.
 */
public data class AgReplicaResponse(
    public val commit: String? = null,
    public val failover: String? = null,
    public val readableSecondary: String? = null,
    public val role: String? = null,
    public val sqlVirtualMachineInstanceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.AgReplicaResponse): AgReplicaResponse = AgReplicaResponse(
            commit = javaType.commit().map({ args0 -> args0 }).orElse(null),
            failover = javaType.failover().map({ args0 -> args0 }).orElse(null),
            readableSecondary = javaType.readableSecondary().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            sqlVirtualMachineInstanceId = javaType.sqlVirtualMachineInstanceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
