@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A SQL Server availability group listener.
 * @property availabilityGroupConfiguration Availability Group configuration.
 * @property availabilityGroupName Name of the availability group.
 * @property createDefaultAvailabilityGroupIfNotExist Create a default availability group if it does not exist.
 * @property id Resource ID.
 * @property loadBalancerConfigurations List of load balancer configurations for an availability group listener.
 * @property multiSubnetIpConfigurations List of multi subnet IP configurations for an AG listener.
 * @property name Resource name.
 * @property port Listener port.
 * @property provisioningState Provisioning state to track the async operation status.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Resource type.
 */
public data class GetAvailabilityGroupListenerResult(
    public val availabilityGroupConfiguration: AgConfigurationResponse? = null,
    public val availabilityGroupName: String? = null,
    public val createDefaultAvailabilityGroupIfNotExist: Boolean? = null,
    public val id: String,
    public val loadBalancerConfigurations: List<LoadBalancerConfigurationResponse>? = null,
    public val multiSubnetIpConfigurations: List<MultiSubnetIpConfigurationResponse>? = null,
    public val name: String,
    public val port: Int? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.GetAvailabilityGroupListenerResult): GetAvailabilityGroupListenerResult = GetAvailabilityGroupListenerResult(
            availabilityGroupConfiguration = javaType.availabilityGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AgConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilityGroupName = javaType.availabilityGroupName().map({ args0 -> args0 }).orElse(null),
            createDefaultAvailabilityGroupIfNotExist = javaType.createDefaultAvailabilityGroupIfNotExist().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            loadBalancerConfigurations = javaType.loadBalancerConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.LoadBalancerConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            multiSubnetIpConfigurations = javaType.multiSubnetIpConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.MultiSubnetIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
